use REST::Client;
use URI::Escape;

$service = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13";
$clientId = "musicalle2013";
$clientSecret = "REDACTED";
$clientSecretEnc = uri_escape ($clientSecret);

#NOTE http. not https here!
$scope = "http://music.xboxlive.com";
$scopeEnc = uri_escape ($scope);

$grantType = "client_credentials";

#Create a new client to obtain a token
my $client = REST::Client->new();
$body = "client_id=$clientId&client_secret=$clientSecretEnc&scope=$scopeEnc&grant_type=$grantType";
print "Obtaining a token...\n";
print "body = $body\n\n";

#POST your request for the token
$client->POST ($service, $body);

#JSON response containing the token you need
$token = $client->responseContent();
print "$token\n\n";

#Pare away everything but the token itself
$token =~ s/.*\"access_token\"\:\"(.*?)\".*/$1/;
print "$token\n\n";

#You have to URL-encode the token you received before you send it.
$tokenEnc = uri_escape($token);
print "$tokenEnc\n\n";

#We won't calculate the time since we got the initial token, but assume it's a few seconds at most,
#and create a new client to obtain a refresh token
my $client = REST::Client->new();
$grantType="refresh_token";
$body2 = "grant_type=$grantType&client_id=$clientId&client_secret=$clientSecretEnc&refresh_token=$tokenEnc&scope=$scopeEnc";
print "Obtaining a refresh token...\n";
print "body2 = $body2\n\n";

#New client to request info from database
my $client = REST::Client->new();

#NOTE https, not http here!
$client->setHost("https://music.xboxlive.com");

# Post request for info on band Daft Punk
$client->GET("/1/content/music/search?q=daft+punk&accessToken=Bearer+$tokenEnc");

# Obtain the response from the database and print it
$response = $client->responseContent();

open (MYFILE, '>>dboutput.xml');
print MYFILE "$response\n";
close (MYFILE);

print "See dboutput.xml for results.\n";
