#!/usr/bin/python
# Analyze the current version of AlphaDice for their word-making capabilities.
# Requires the GNU anagram program 'an' be installed.

import os
import random
import sys

random.seed()

# Pick a random character
# from a random side of the specified die

def randchar(die):
  side = random.randint (0,5)
  sidechars = die[side]
  l = len(sidechars)
  c = sidechars[random.randint(0,l-1)]
  return c

wordsout = open ("wordsout.txt","w")

# Specify the letters on the seven AlphaDice

B = ["B","S","N","W","AI","EU"];
J = ["J","D","C","IU","EA","ABCDEFGHIJKLMNOPQRSTUVWXYZ"];
K = ["K","H","T","F","OU","EI"];
Q = ["Q","R","G","EI","AO","ABCDEFGHIJKLMNOPQRSTUVWXYZ"];
V = ["V","R","N","Y","AU","EO"];
X = ["X","S","T","P","IO","AE"];
Z = ["Z","L","M","AO","IU","ABCDEFGHIJKLMNOPQRSTUVWXYZ"];

dice = [B,J,K,Q,V,X,Z]

# Grab from 2-7 dice many times (usually a million for a thorough test)

for i in range (0,10**6):
  grab = random.sample (dice,random.randint(2,7))

# Pick a random letter from each die grabbed

  letters = ""
  for d in grab:
    c = randchar (d)
    letters = letters + c

  print str(i) + " " + letters

# Find anagrams of the resulting letters in the official Scrabble dictionary SOWPODS
# (with words longer than seven letters removed, because there are only seven dice)

  p = os.popen("an -d sowpods71.txt " + letters, "r")
  wordstring = str(p.read())
  wordlist = wordstring.split()

# Append all of the resulting anagrams to a file

  if (wordlist) and (wordlist[0] != "an:"):
    for item in wordlist:
      print>>wordsout, item

wordsout.close

