#include <langinfo.h>
#include <locale.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// ICU library headers
#include "unicode/ustring.h"
#include "unicode/utypes.h"
#include "unicode/uloc.h"
#include "unicode/ucol.h"
#include "unicode/ustdio.h"
#include "unicode/uchar.h"

int main(void)
{
    FILE *fp;
    char *line = NULL;
    char filename[100];
    char locale[100];
    char command[512];
    char lines[100][512];
    UChar s[100][512];
    UChar temp[1][512];
    size_t len = 0;
    ssize_t read;
    int l = 0;
    int linecount = 0;

    // Ask user for filename and locale of UTF-16 LE file
    printf("Enter name of file to sort: ");
    scanf("%s", filename);
    printf("Enter sort locale: ");
    scanf("%s", locale);

    setlocale(LC_ALL, "");

    // Convert UTF-16 LE file (Windows) to UTF-8 (Linux)
    sprintf(command, "iconv -f utf16le -t utf8 -o unsorted8.txt %s", filename);
    system(command);

    // Open the UTF-8 version of the file
    fp = fopen("unsorted8.txt", "r");
    if (fp == NULL)
      return(-1);

    // Read UTF-8 file line by line, convert UTF-8 lines individually
    // to UTF-16 so ICU can read them, and store them in string array
    // s, printing lines as we go.  Note that because it's a UTF-8
    // file, we don't need any special Unicode routines to read or
    // display lines -- we can just use getline() and printf().
    UErrorCode err = U_ZERO_ERROR;
    while ((read = getline(&line, &len, fp)) != -1)
    {
      printf("Line %d, length %zu:\n", l, read);
      printf("%s\n", line);

      // Convert UTF-8 string to UTF-16.
      u_strFromUTF8(s[l], 256, NULL, line, -1, &err);
      if (err != U_ZERO_ERROR)
	printf ("u_strFromUTF8: Error %d on line %d\n\n", err, l);
      l++;
    }

    // Total number of lines in file
    linecount = l;


    // Sort routine...
    UErrorCode status = U_ZERO_ERROR;
    printf("Opening ICU collation.\n\n");
    UCollator *coll = ucol_open(locale, &status); 
    uint32_t i, j; 

    // Fairly standard insertion sort of the lines in string array s.
    // The difference is that we are not using strcmp() to compare
    // strings, but ucol_strcoll(), which takes the locale into
    // account.

    printf("Sorting...\n");
    if(U_SUCCESS(status))
    {
      for(i=1; i<=linecount-1; i++)
      {
	// printf ("\n\nSorting line %d...\n", i);
	for(j=i; j>0; j--) 
	{
	  // printf("Comparing with %d. ", j-1);
	  if(ucol_strcoll(coll, s[j], -1, s[j-1], -1) == UCOL_LESS)
	  {
	    // printf("Swapping %d with %d. ",j,j-1);
	    u_strcpy(temp[0], s[j]);
	    u_strcpy(s[j], s[j-1]);
	    u_strcpy(s[j-1], temp[0]);
	    // printf("OK.\n");
	  }
	}
      }
      printf("\n\nClosing ICU collation.\n");
      ucol_close(coll); 
    }

    // Write the sorted data in both UTF-16 LE and UTF-8 versions.
    printf("Writing sorted UTF-16 LE file.\n");
    UFILE* ufp = u_fopen("sorted16.txt", "w", NULL, "UTF16LE");
    for (l=0; l<linecount; l++)
      u_fputs(s[l], ufp);
    u_fclose(ufp);

    printf("Converting UTF-16 LE file to UTF-8.\n");
    system("iconv -f utf16le -t utf8 -o sorted8.txt sorted16.txt");

    printf("Quitting.\n");
    free(line);
    return(0);
}
