// tjd.cc
// By Ron Hale-Evans, rwhe@ludism.org
// 2010-08-03
// C++ sample code demonstrates Truncated Julian Day calculation.
// See http://en.wikipedia.org/wiki/Julian_day


#include <iostream>
#include <ctime>
#include <cstdio>
#include <cfloat>

class tjdate
{
public:
  double curtjd ()
	{
		time_t curtime;
		double unixday, jd, jdfrac, tjd, tjdfrac;
		int jdint, tjdint;

		curtime = time(NULL);
		//printf ("Unix time = %ld seconds since January 1, 1970\n", curtime);

		unixday = float(curtime) / (24 * 60 * 60);
		//printf ("unixday = %07.04f\n", unixday);
		jd = unixday + 2440587.5;
		//printf ("jd = %07.04f\n", jd);
		jdint = int (jd);
		jdfrac = jd - jdint;
    
		tjdint = jdint % 10000;
		tjdfrac = jdfrac - 0.5;
		tjd = tjdint + tjdfrac;

		return (tjd);
	}

  double specified_tjd (time_t given_date)
  {
	// Code for returning the Truncated Julian Day for a given date goes here.
	return (0);
  }
};

int main ()
{
  double curtjd;
  tjdate mytjd;

  curtjd = mytjd.curtjd();
  printf ("Truncated Julian Day = %04.2f\n", curtjd);
  return 0;
}
