Code and writing samples for Ron Hale-Evans
=============================================

Code
-----------------
**alpharoll2.py** is a Python sample script for Monte Carlo statistical analysis of a set of alphabet dice.

**h2x.txt** is a Perl script I wrote for Microsoft that successfully converted thousands of AppleScript SDK pages from HTML to XML in a fast, lightweight way, without calling any XML libraries.

**iosort1.c** demonstrates how to sort Unicode strings with Linux calls. For more information, see **Developing International Software**, below.

**tjd.cc** contains simple C++ sample code I wrote with GCC that demonstrates date/time manipulation with Truncated Julian Day calculation (<http://en.wikipedia.org/wiki/Julian_day>). I have written extensive calendrical software elsewhere.

**Xbox** contains sample clients in C#, JavaScript, and Perl for the Xbox Music Service, with some documentation. I was the lead writer for the Xbox Music team in 2013 and 2014, and wrote the first-ever client application for the service, in Perl. The Perl and JavaScript clients I wrote were only used internally, but the C# client was incorporated into the public-facing documentation.


Writing
------------------
**contentclass.pdf** contains three pages from the complete SDK that I wrote for SchemaLogic, from the roughly 70-page PDF. It was an SDK for their new API, a streamlined reboot of their old API. I wrote about 60-70% of it, including what you see, consulting the documentation for their old API. I also consulted the programmer of the new API. The document was not edited, as there were no editors at the company.

**Developing International Software** contains C code samples for Linux, Android code samples, and documentation for educational classroom and online use in the continuing Harvard course, Developing International Software. (I was not a student, but developed these as a contractor of the instructor.) Topics covered include computer locales, cross-platform use of Unicode, sorting international characters and strings, and localizing Android apps.

**etk.pdf** is an excerpt from the 35-page _R700 Embedded Reader Development Guide_ from Impinj, Inc. I was the lead writer on the rewrite of this manual. Developers and other SMEs wrote first drafts of some of the material, but I edited it, rewrote it, and did an extensive technical review of their work, building software and checking that it ran.

**MPH_ForceYourConnections.pdf** comes from my first book and is an example of combining narrative documentation with a code sample in a fairly friendly way.

**MPH_TestForDivisibility.pdf** is a sample of some of my best narrative technical writing for a nontechnical audience. It explains how to perform certain arithmetical operations. It also comes from my first book.

**[MS-TSQLISO02].pdf** is a Microsoft Protocols document available from MSDN that I researched and wrote for the SQL Server team.

**nldbl.pdf** was written for the Linux Standard Base, and is part of a specification document for a large number of Linux kernel binary interfaces (function calls). This document is an example of something I specialize in: the automated production of documentation. I wrote a Perl script that took a long list of very similar function calls, including brief synopses, and then called an existing script that queried a database and produced some skeletal documentation pages for the calls. My script then tweaked these skeletal pages, which had some superfluous sections and were missing others, and then inserted the necessary English text. Once this process finished, very little manual labor was necessary to produce complete, human-readable documentation, and I was able to use my Perl script again many times on similar projects.

Much of the nldbl.pdf content is a kind of boilerplate, but what I wrote was the _automation_ that varied the boilerplate appropriately across a fairly large number of similar pages that had important differences. I got my information from an extended discussion with the rest of the Linux Foundation team on IRC and Bugzilla (<http://bugs.linuxbase.org/show_bug.cgi?id=2178>). The document was not edited but went through an approval process.
